<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ProjectCertificateSeederSimple extends Seeder
{
    public function run()
    {
        // Clear existing data
        $this->db->table('projects')->truncate();
        $this->db->table('organizations')->truncate();
        $this->db->table('training')->truncate();
        $this->db->table('certificates')->truncate();

        echo "🧹 Clearing existing data...\n";

        // Insert Projects
        echo "📁 Inserting Projects...\n";
        $projects = [
            [
                'nama_project' => 'Aplikasi Mobile Portofolio',
                'jenis_project' => 'Mobile',
                'teknologi' => 'Android Studio, Jetpack Compose',
                'tahun' => 2024,
                'deskripsi' => 'Aplikasi Android bertema biru pastel (Tema Blue Butterfly) yang menampilkan halaman Profil, Kegiatan, dan Pendidikan. Menggunakan Jetpack Compose tanpa layout XML dengan navigasi bawah (BottomNavigation) dan animasi ikon butterfly yang menarik.',
                'link_project' => 'https://github.com/username/mobile-portfolio',
                'urutan' => 1
            ],
            [
                'nama_project' => 'Website F&B',
                'jenis_project' => 'Web',
                'teknologi' => 'Laravel, Bootstrap 5',
                'tahun' => 2024,
                'deskripsi' => 'Sistem pemesanan meja restoran dengan tampilan gambar slider, galeri makanan, dan form reservasi lengkap. Fitur input meliputi nama, email, no HP, jumlah tamu, tanggal, waktu, pilihan meja, dan catatan khusus untuk pengalaman dining yang optimal.',
                'link_project' => 'https://github.com/username/restaurant-booking',
                'urutan' => 2
            ],
            [
                'nama_project' => 'Website Jasa Pemasangan Wifi',
                'jenis_project' => 'Web',
                'teknologi' => 'Laravel, MySQL',
                'tahun' => 2024,
                'deskripsi' => 'Proyek akhir yang membangun website simulasi Jasa Pemasangan Wifi. Menyediakan tampilan terpisah untuk pengguna dan admin, serta integrasi dengan fitur CRUD lengkap dan sistem login yang aman untuk manajemen layanan wifi.',
                'link_project' => 'https://github.com/username/wifi-service',
                'urutan' => 3
            ],
            [
                'nama_project' => 'Chatbot Cerdas',
                'jenis_project' => 'Lainnya',
                'teknologi' => 'Gemini AI, Python',
                'tahun' => 2024,
                'deskripsi' => 'Mengembangkan chatbot percakapan natural menggunakan model GPT-style dari Gemini. Diterapkan untuk layanan tanya-jawab otomatis, dengan fallback logika untuk topik teknis dan non teknis, memberikan respons yang akurat dan kontekstual.',
                'link_project' => 'https://github.com/username/gemini-chatbot',
                'urutan' => 4
            ],
            [
                'nama_project' => 'Aplikasi CV Pribadi',
                'jenis_project' => 'Mobile',
                'teknologi' => 'Android Studio, Java',
                'tahun' => 2024,
                'deskripsi' => 'Aplikasi portofolio interaktif yang menampilkan profil diri, proyek, dan kontak. Desain modern dan responsif dengan navigasi intuitif, sekaligus pengaktifan tautan langsung ke email, Github, dan Instagram untuk networking profesional.',
                'link_project' => 'https://github.com/username/cv-mobile-app',
                'urutan' => 5
            ],
            [
                'nama_project' => 'Game Plants vs Zombies',
                'jenis_project' => 'Game',
                'teknologi' => 'Python, Pygame',
                'tahun' => 2024,
                'deskripsi' => 'Membangun ulang game Plants vs Zombies menggunakan Python dan library Pygame. Menyediakan sistem pergerakan tanaman oleh user, serta musuh zombie dengan animasi dasar yang smooth dan gameplay yang engaging.',
                'link_project' => 'https://github.com/username/plants-vs-zombies-python',
                'urutan' => 6
            ],
            [
                'nama_project' => 'Website Penjualan',
                'jenis_project' => 'Web',
                'teknologi' => 'HTML, CSS, PHP, MySQL',
                'tahun' => 2024,
                'deskripsi' => 'Website e-commerce sederhana dengan fitur SEO dasar (JSON-LD Schema, sitemap). Terhubung ke database MySQL, dengan fungsi pencarian dan form pemesanan. Dioptimalkan melalui Google Search Console untuk visibilitas maksimal.',
                'link_project' => 'https://github.com/username/ecommerce-website',
                'urutan' => 7
            ],
            [
                'nama_project' => 'Website Portofolio Pribadi',
                'jenis_project' => 'Web',
                'teknologi' => 'HTML, CSS, PHP',
                'tahun' => 2024,
                'deskripsi' => 'Website responsif berisi profil, project, dan kontak. Di-hosting secara online dan mendukung tampilan mobile-friendly dengan desain yang clean dan professional untuk showcase karya dan kemampuan.',
                'link_project' => 'https://portfolio.example.com',
                'urutan' => 8
            ],
            [
                'nama_project' => 'Sistem Deteksi Lagu dari Lirik',
                'jenis_project' => 'Lainnya',
                'teknologi' => 'Python, Whisper AI',
                'tahun' => 2024,
                'deskripsi' => 'Mencocokkan lirik lagu dari input suara pengguna dengan file teks Lirik. Menggunakan speech-to-text dengan Whisper dan pencocokan teks yang akurat untuk identifikasi lagu berdasarkan potongan lirik yang diucapkan.',
                'link_project' => 'https://github.com/username/song-detection-lyrics',
                'urutan' => 9
            ],
            [
                'nama_project' => 'Aplikasi Smart Home Berbasis Suara',
                'jenis_project' => 'Lainnya',
                'teknologi' => 'Python, Arduino',
                'tahun' => 2024,
                'deskripsi' => 'Mengembangkan sistem kontrol perangkat rumah (lampu, kipas, dsb.) menggunakan perintah suara. Integrasi Python untuk voice recognition dan Arduino sebagai kontrol aktuator untuk otomasi rumah pintar yang responsif.',
                'link_project' => 'https://github.com/username/smart-home-voice',
                'urutan' => 10
            ],
            [
                'nama_project' => 'Sensor Kebakaran berbasis gas',
                'jenis_project' => 'Lainnya',
                'teknologi' => 'Arduino, Sensor MQ-5',
                'tahun' => 2024,
                'deskripsi' => 'Sistem deteksi kebakaran menggunakan sensor gas MQ-5. Memberikan peringatan lokal dan email saat gas beracun (LPG, Hidrogen, Metana, Butana) terdeteksi, dengan sistem notifikasi real-time untuk keamanan maksimal.',
                'link_project' => 'https://github.com/username/fire-detection-sensor',
                'urutan' => 11
            ]
        ];

        foreach ($projects as $project) {
            $this->db->table('projects')->insert($project);
        }

        // Insert Organizations
        echo "🏢 Inserting Organizations...\n";
        $organizations = [
            [
                'nama_organisasi' => 'HIMAKOM (Himpunan Mahasiswa Ilmu Komputer)',
                'jabatan' => 'Anggota Divisi Akademik',
                'tahun_mulai' => 2025,
                'tahun_selesai' => null,
                'deskripsi' => 'Membantu monitoring perkembangan akademik anggota serta menyusun laporan evaluasi. Mengkoordinasi pelaksanaan sesi diskusi, workshop, dan kelas pengayaan setiap bulan untuk meningkatkan kualitas akademik mahasiswa Ilmu Komputer.',
                'urutan' => 1
            ]
        ];

        foreach ($organizations as $organization) {
            $this->db->table('organizations')->insert($organization);
        }

        // Insert Training
        echo "🎓 Inserting Training...\n";
        $trainings = [
            [
                'nama_pelatihan' => 'Data Science',
                'penyelenggara' => 'DQLab Academy',
                'tanggal_mulai' => '2024-07-01',
                'tanggal_selesai' => '2024-07-31',
                'deskripsi' => 'Pelatihan komprehensif Data Science dengan modul: Fundamental Python for Data Science, R Fundamental for Data Science, dan Fundamental SQL Using Select Statement. Memberikan foundation yang kuat untuk analisis data dan pengembangan model.',
                'sertifikat' => 'certificate_data_science.pdf',
                'urutan' => 1
            ],
            [
                'nama_pelatihan' => 'UI/UX Designer',
                'penyelenggara' => 'Pelatihan UI/UX UKM LAOS',
                'tanggal_mulai' => '2024-06-01',
                'tanggal_selesai' => '2024-07-31',
                'deskripsi' => 'Pelatihan UI/UX Design dengan modul: Fundamental UI-UX Design, UX Design Research & Writing, Introduction Figma, dan Basic Design Visual Mock-up. Mengembangkan kemampuan desain antarmuka yang user-friendly dan estetis.',
                'sertifikat' => 'certificate_uiux.pdf',
                'urutan' => 2
            ],
            [
                'nama_pelatihan' => 'Networking',
                'penyelenggara' => 'IT Solution Service',
                'tanggal_mulai' => '2024-03-01',
                'tanggal_selesai' => '2024-03-31',
                'deskripsi' => 'Pelatihan networking dengan modul: Network Fundamental, IP Address, Winbox, dan Support. Memahami konsep jaringan komputer, konfigurasi IP, dan troubleshooting untuk infrastruktur IT yang robust.',
                'sertifikat' => 'certificate_networking.pdf',
                'urutan' => 3
            ],
            [
                'nama_pelatihan' => 'Web Development Series 11.0',
                'penyelenggara' => 'Dibimbing.id',
                'tanggal_mulai' => '2025-02-01',
                'tanggal_selesai' => '2025-02-28',
                'deskripsi' => 'Pelatihan web development dengan modul: HTML & CSS, JavaScript, Responsive Web Design, dan Framework Frontend (Bootstrap). Mengembangkan kemampuan full-stack web development dengan teknologi modern.',
                'sertifikat' => 'certificate_webdev.pdf',
                'urutan' => 4
            ],
            [
                'nama_pelatihan' => 'Design for Impact: Design Thinking & UI/UX',
                'penyelenggara' => 'MyEduSolve',
                'tanggal_mulai' => '2025-04-01',
                'tanggal_selesai' => '2025-04-30',
                'deskripsi' => 'Pelatihan design thinking dengan modul: Design Thinking, UI/UX Fundamentals, dan Visual Problem Solving. Mengembangkan mindset design thinking untuk menciptakan solusi yang berpusat pada pengguna.',
                'sertifikat' => 'certificate_design_thinking.pdf',
                'urutan' => 5
            ],
            [
                'nama_pelatihan' => 'Robotic: Robot control',
                'penyelenggara' => 'Bisa AI',
                'tanggal_mulai' => '2025-05-01',
                'tanggal_selesai' => '2025-05-31',
                'deskripsi' => 'Pelatihan robotika dengan modul: Logic, Komponen Robotika, Arduino, ML & AI. Memahami kontrol robot, pemrograman mikrokontroler, dan integrasi AI untuk sistem robotika yang intelligent.',
                'sertifikat' => 'certificate_robotics.pdf',
                'urutan' => 6
            ],
            [
                'nama_pelatihan' => 'SIEM',
                'penyelenggara' => 'Linuxhackingid',
                'tanggal_mulai' => '2025-05-01',
                'tanggal_selesai' => '2025-05-31',
                'deskripsi' => 'Pelatihan Security Information and Event Management dengan modul: Pengenalan SIEM, Cara Kerja SIEM, dan Komponen Utama SIEM. Mengembangkan kemampuan monitoring keamanan dan analisis log sistem.',
                'sertifikat' => 'certificate_siem.pdf',
                'urutan' => 7
            ],
            [
                'nama_pelatihan' => 'FORTECHBI',
                'penyelenggara' => 'HIMAKOM',
                'tanggal_mulai' => '2025-06-01',
                'tanggal_selesai' => '2025-06-30',
                'deskripsi' => 'Pelatihan teknologi dengan modul: ML & AI, Studi Kasus Aplikasi AI di Pendidikan, dan Etika dan Pemanfaatan AI. Memahami implementasi AI dalam pendidikan dan aspek etika penggunaan teknologi AI.',
                'sertifikat' => 'certificate_fortechbi.pdf',
                'urutan' => 8
            ],
            [
                'nama_pelatihan' => 'The Future of Web Programming Trends, Tools, and Technologies',
                'penyelenggara' => 'Tech Conference',
                'tanggal_mulai' => '2025-07-01',
                'tanggal_selesai' => '2025-07-31',
                'deskripsi' => 'Pelatihan web programming modern dengan modul: Perkembangan tren web, tool modern (React, Vue, dan Tailwind), dan Penggunaan AI dalam Web Development. Mengikuti perkembangan teknologi web terdepan.',
                'sertifikat' => 'certificate_future_web.pdf',
                'urutan' => 9
            ]
        ];

        foreach ($trainings as $training) {
            $this->db->table('training')->insert($training);
        }

        // Insert Certificates
        echo "🏆 Inserting Certificates...\n";
        $certificates = [
            [
                'nama_sertifikat' => 'Data Science Certificate',
                'penerbit' => 'DQLab Academy',
                'tanggal_terbit' => '2024-07-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DQL-DS-2024-001',
                'link_sertifikat' => 'https://dqlab.id/certificate/DQL-DS-2024-001',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Data Science yang memvalidasi kompetensi dalam Python for Data Science, R Programming, dan SQL fundamentals. Menunjukkan kemampuan analisis data, visualisasi, dan pengolahan database untuk kebutuhan data science.'
            ],
            [
                'nama_sertifikat' => 'UI/UX Designer Certificate',
                'penerbit' => 'UKM LAOS',
                'tanggal_terbit' => '2024-07-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'LAOS-UIUX-2024-002',
                'link_sertifikat' => 'https://laos.ac.id/certificate/LAOS-UIUX-2024-002',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat UI/UX Designer yang memvalidasi kemampuan dalam fundamental design, UX research, Figma, dan visual mock-up. Menunjukkan kompetensi dalam menciptakan antarmuka yang user-centered dan estetis.'
            ],
            [
                'nama_sertifikat' => 'Network Fundamental Certificate',
                'penerbit' => 'IT Solution Service',
                'tanggal_terbit' => '2024-03-31',
                'tanggal_expired' => '2027-03-31',
                'nomor_sertifikat' => 'ITS-NET-2024-003',
                'link_sertifikat' => 'https://itsolution.com/certificate/ITS-NET-2024-003',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Network Fundamental yang memvalidasi pemahaman konsep jaringan, konfigurasi IP Address, penggunaan Winbox, dan technical support. Menunjukkan kemampuan dalam administrasi dan troubleshooting jaringan.'
            ],
            [
                'nama_sertifikat' => 'Web Development Series 11.0 Certificate',
                'penerbit' => 'Dibimbing.id',
                'tanggal_terbit' => '2025-02-28',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'DBG-WD11-2025-004',
                'link_sertifikat' => 'https://dibimbing.id/certificate/DBG-WD11-2025-004',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Web Development yang memvalidasi kemampuan HTML & CSS, JavaScript, Responsive Design, dan Bootstrap Framework. Menunjukkan kompetensi dalam pengembangan website modern dan responsif.'
            ],
            [
                'nama_sertifikat' => 'Design Thinking & UI/UX Certificate',
                'penerbit' => 'MyEduSolve',
                'tanggal_terbit' => '2025-04-30',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'MES-DT-2025-005',
                'link_sertifikat' => 'https://myedusolve.com/certificate/MES-DT-2025-005',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Design Thinking yang memvalidasi kemampuan dalam design thinking methodology, UI/UX fundamentals, dan visual problem solving. Menunjukkan kompetensi dalam menciptakan solusi design yang impactful.'
            ],
            [
                'nama_sertifikat' => 'Robot Control Certificate',
                'penerbit' => 'Bisa AI',
                'tanggal_terbit' => '2025-05-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'BAI-RC-2025-006',
                'link_sertifikat' => 'https://bisaai.com/certificate/BAI-RC-2025-006',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Robot Control yang memvalidasi pemahaman logic programming, komponen robotika, Arduino, dan integrasi ML & AI. Menunjukkan kemampuan dalam pengembangan sistem robotika intelligent.'
            ],
            [
                'nama_sertifikat' => 'SIEM Certificate',
                'penerbit' => 'Linuxhackingid',
                'tanggal_terbit' => '2025-05-31',
                'tanggal_expired' => '2028-05-31',
                'nomor_sertifikat' => 'LHI-SIEM-2025-007',
                'link_sertifikat' => 'https://linuxhackingid.com/certificate/LHI-SIEM-2025-007',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat SIEM yang memvalidasi kemampuan dalam Security Information and Event Management, monitoring keamanan sistem, dan analisis log. Menunjukkan kompetensi dalam cybersecurity dan incident response.'
            ],
            [
                'nama_sertifikat' => 'FORTECHBI Certificate',
                'penerbit' => 'HIMAKOM',
                'tanggal_terbit' => '2025-06-30',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'HMK-FTB-2025-008',
                'link_sertifikat' => 'https://himakom.ac.id/certificate/HMK-FTB-2025-008',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat FORTECHBI yang memvalidasi pemahaman ML & AI, aplikasi AI dalam pendidikan, dan etika AI. Menunjukkan kompetensi dalam implementasi teknologi AI yang bertanggung jawab dan ethical.'
            ],
            [
                'nama_sertifikat' => 'Future Web Programming Certificate',
                'penerbit' => 'Tech Conference',
                'tanggal_terbit' => '2025-07-31',
                'tanggal_expired' => null,
                'nomor_sertifikat' => 'TC-FWP-2025-009',
                'link_sertifikat' => 'https://techconf.com/certificate/TC-FWP-2025-009',
                'foto_sertifikat' => null,
                'deskripsi' => 'Sertifikat Future Web Programming yang memvalidasi pemahaman tren web modern, tools seperti React dan Vue, Tailwind CSS, dan penggunaan AI dalam web development. Menunjukkan kemampuan mengikuti perkembangan teknologi web terdepan.'
            ]
        ];

        foreach ($certificates as $certificate) {
            $this->db->table('certificates')->insert($certificate);
        }

        echo "✅ Project, Organization, Training, dan Certificate data berhasil dimigrasi!\n";
        echo "📊 Data yang diinsert:\n";
        echo "   - Projects: " . count($projects) . " records\n";
        echo "   - Organizations: " . count($organizations) . " records\n";
        echo "   - Training: " . count($trainings) . " records\n";
        echo "   - Certificates: " . count($certificates) . " records\n";
    }
}